	function [A,w]  =  ZEROAM(h,u1,u2,M)
	
	%	Evaluates the zero-phase frequency response
	%	of a linear phase FIR filter at points
	%	w = u1*pi:(u2-u1)*pi/M:u2*pi
	%	Tapio Saramaki 28.10.1995
	%	This can be found in SUN's ~ts/matlab/dsp/zeroam.m
	
	% 	Toolbox for DIGITAL FILTERS USING MATLAB 
	
	%	Author: 			Tapio Saramaki 28.10.1995
	%	Modified by:	
	%	Copyright:			by authors - not released for commercial use
	%	Version:			1	 
	%	Known bugs: 
	%	Report bugs to:		tapio.saramaki@tut.fi
	
	
	N = length(h);
	iodd = 0;
	if 2*round(N/2) == N iodd = 1; end
	isy = 1;
	if abs(h(N)-h(1))/abs(h(1)) < 0.5 isy = 0; end
	if iodd == 0 & isy == 0 itype = 1;end
	if iodd == 1 & isy == 0 itype = 2;end
	if iodd == 0 & isy == 1 itype = 3;end
	if iodd == 1 & isy == 1 itype = 4;end
	L = floor((N+2)/2);
	if M > 1 
		w = u1*pi:(u2-u1)*pi/M:u2*pi;
	end
	if M == 1
		w = u1*pi; 
	end
	A = zeros(size(w));
	if itype == 1 
		A = A+h(L);
	end
	for k = 1:L-1
		if itype == 1
			A = A+2*h(L-k)*cos(k*w);
		end
		if itype == 2
			A = A+2*h(L-k)*cos((k-0.5)*w);
		end
		if itype == 3
			A = A+2*h(L-k)*sin(k*w);
		end
		if itype == 4
			A = A+2*h(L-k)*sin((k-0.5)*w);
		end
	end 
		
